/* Antarmuka dengan Motor Servo - Trainer Internet of Things
 * Project : Mengontrol Motor Servo dengan Aplikasi IoT KIT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>

// Library Servo dan Pin Servo
#include <Servo.h>
#define SERVO_PIN   D0

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// Servo objek dengan nama servo
Servo servo;
// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);

  // Konfigurasi pin pada objek servo
  servo.attach(SERVO_PIN);
   
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);
}

void loop() {
  // Membaca database pada alamat */user/switch1
  // Jika nilainya true servo berputar ke posisi 180 derajat
  // Jika nilainya false servo berputar ke posisi 0 derajat
  if(Firebase.getString(fbdo, "/" + user +  "/switch1")) {
    if(fbdo.to<bool>() == true){
      servo.write(180);
      Serial.println("Servo 180 derajat");
    }else{
      servo.write(0);
      Serial.println("Servo 0 derajat");
    }
  }
}
